// components/DashboardAdmin.tsx

import GenderChart from "@/components/dashboard-components/GenderChart";
import { createAxiosWithAuth } from "@/lib/axiosAuth";
import { fetchWithRetry } from "@/lib/fetchWithRetry";

const DashboardAdmin = async () => {
  const axios = await createAxiosWithAuth();
  const res = await fetchWithRetry(() => axios.get("karyawan"));
  const data = res.data;

  const pria = data.filter((d: any) => d.gender === "Pria").length;
  const wanita = data.filter((d: any) => d.gender === "Wanita").length;

  return (
    <GenderChart gender={[pria, wanita]} />
  );
};

export default DashboardAdmin;
