import React from "react";
import {
  FormControl,
  FormField,
  FormItem,
  FormLabel,
  FormMessage,
} from "./ui/form";
import { Input } from "./ui/input";

import { Control } from "react-hook-form";
import { z } from "zod";
import { authFormSchema } from "@/lib/zod";

interface LoginInput {
  control: Control<z.infer<typeof authFormSchema>>;
  name: "email" | "password";
  label: string;
  type: string;
  placeholder: string;
}

const LoginInput = ({
  control,
  name,
  label,
  type,
  placeholder,
}: LoginInput) => {
  return (
    <FormField
      control={control}
      name={name}
      render={({ field }) => (
        <FormItem>
          <FormLabel>{label}</FormLabel>
          <FormControl>
            <Input
              type={type}
              placeholder={placeholder}
              autoComplete="off"
              {...field}
              className="h-12"
            />
          </FormControl>
          <FormMessage />
        </FormItem>
      )}
    />
  );
};

export default LoginInput;
