import { NextRequest, NextResponse } from "next/server";
import { createAxiosWithAuth } from "@/lib/axiosAuth";
import { DataMaster } from "@/types";

// GET divisi
export async function GET(req: NextRequest) {
  const axiosAuth = await createAxiosWithAuth();
  try {
    const res = await axiosAuth.get("divisi");
    return NextResponse.json(res.data);
  } catch (error: any) {
    console.error(
      "Failed to fetch Divisi:",
      error?.response?.data || error.message
    );
    return NextResponse.json(
      { error: "Failed to fetch Divisi" },
      { status: 500 }
    );
  }
}

// POST divisi
export async function POST(req: NextRequest) {
  const axiosAuth = await createAxiosWithAuth();
  try {
    const body: DataMaster = await req.json(); // ini penting! parsing data dari request body
    const res = await axiosAuth.post("divisi", body);
    return NextResponse.json(res.data);
  } catch (error: any) {
    console.error(
      "Failed to post Divisi:",
      error?.response?.data || error.message
    );
    return NextResponse.json(
      { error: "Failed to post Divisi" },
      { status: 500 }
    );
  }
}
